/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.api;

import com.floragunn.searchguard.authc.rest.TenantAwareRestHandler;
import com.floragunn.signals.actions.watch.state.get.GetWatchStateAction;
import com.floragunn.signals.actions.watch.state.get.GetWatchStateRequest;
import com.floragunn.signals.actions.watch.state.get.GetWatchStateResponse;
import com.floragunn.signals.api.SignalsBaseRestHandler;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;

public class WatchStateApiAction
extends SignalsBaseRestHandler
implements TenantAwareRestHandler {
    public WatchStateApiAction(Settings settings, RestController controller) {
        super(settings);
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/_signals/watch/{tenant}/{id}/_state"));
    }

    protected final BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        final String watchId = request.param("id");
        return channel -> client.execute((ActionType)GetWatchStateAction.INSTANCE, (ActionRequest)new GetWatchStateRequest(Collections.singletonList(watchId)), (ActionListener)new ActionListener<GetWatchStateResponse>(){

            public void onResponse(GetWatchStateResponse response) {
                BytesReference statusDoc = response.getWatchToStatusMap().get(watchId);
                if (statusDoc != null) {
                    channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "application/json", statusDoc));
                } else {
                    WatchStateApiAction.this.errorResponse(channel, RestStatus.NOT_FOUND, "No such watch: " + watchId);
                }
            }

            public void onFailure(Exception e) {
                WatchStateApiAction.this.errorResponse(channel, e);
            }
        });
    }

    public String getName() {
        return "Watch State";
    }
}

